<?php namespace Concrete\Package\TallacmansCallMe\Block\TallacmansCallMe;

defined("C5_EXECUTE") or die("Access Denied.");

use Concrete\Core\Block\BlockController;

class Controller extends BlockController
{
    // public $btFieldsRequired = ['phoneNumber', 'displayText'];
    protected $btTable = 'btTallacmansCallMe';
    protected $btInterfaceWidth = 400;
    protected $btInterfaceHeight = 400;
    protected $pkg = 'tallacmans_call_me';
    protected $btDefaultSet = 'navigation';


    public function getBlockTypeDescription()
    {
        return t("Click to contact via either text (sms) or voice call.");
    }

    public function getBlockTypeName()
    {
        return t("Tallacman's Call Me");
    }

    public function getSearchableContent()
    {
        $content = [];
        $content[] = $this->phoneNumber;
        $content[] = $this->displayText;
        return implode(" ", $content);
    }

    public function view()
    {
        $callOrText_options = [
            '1' => "tel",
            '2' => "sms"
        ];
        $this->set("callOrText_options", $callOrText_options);
        $displayAs_options = [
            '1' => "", // no value needed as array is parsed in the view
            '2' => "h1",
            '3' => "h2",
            '4' => "h3",
            '5' => "h4",
            '6' => "h5",
            '7' => "h6",
            '8' => "span",
            '9' => "p"
          ];
        $this->set("displayAs_options", $displayAs_options);
    }

    public function add()
    {
        $this->addEdit();
    }

    public function edit()
    {
        $this->addEdit();
    }


// front facing

    protected function addEdit()
    {
        $this->set("callOrText_options", [
                '1' => t("call"),
                '2' => t("text (sms)")
            ]
        );
        $this->set("displayAs_options", [
                '1' => t("button"),
                '2' => t("h1"),
                '3' => t("h2"),
                '4' => t("h3"),
                '5' => t("h4"),
                '6' => t("h5"),
                '7' => t("h6"),
                '8' => t("span"),
                '9' => t("paragraph")
            ]
        );
    //    $app = $this->app;
    }

    public function validate($args)
    {
        $e = $this->app->make("helper/validation/error");

        if (trim($args["phoneNumber"]) == "") {
            $e->add(t("A valid phone number is required."));
        }

        if (trim($args["displayText"]) == "") {
            $e->add(t("Without some text to display this block will not function."));
        }

        return $e;
    }

    public function composer()
    {
        $this->edit();
    }
}
