<?php defined('C5_EXECUTE') or die("Access Denied.");
$c = Page::getCurrentPage();
if ($c->isEditMode()) { ?>
  <div class="ccm-edit-mode-disabled-item" style="width: <?php  echo $width; ?>; height: <?php  echo $height; ?>">
    <div style="padding: 40px 0px 40px 0px"><?php  echo t('Easy Social Feed is disabled in edit mode.')?></div>
  </div>
  <?php
}

else {
  ?>

  <style>
  <?php if($template === 'masonry'){
    ?>
    @media (max-width: 480px) {
      #social-feed-<?=$unique_block_id?>.social-feed ul.entries > li{
        width: calc(<?= 100/$masonry_cols_mobile?>% - 10px);
      }
    }
    @media (min-width: 481px) and (max-width: 1024px){
      #social-feed-<?=$unique_block_id?>.social-feed ul.entries > li{
        width: calc(<?= 100/$masonry_cols_tablet?>% - 10px);
      }
    }
    @media (min-width: 1025px) {
      #social-feed-<?=$unique_block_id?>.social-feed ul.entries > li{
        width: calc(<?= 100/$masonry_cols?>% - 10px);
      }
    }
    <?php
  }?>

  <?php if(!empty($background_color)) {
    ?>
    #social-feed-<?=$unique_block_id?>.social-feed ul.entries > li .social-feed-container{
      background-color: <?= $background_color ?> !important;
    }
    <?php
  } ?>

  <?php if(!empty($border_color)) {
    ?>
    #social-feed-<?=$unique_block_id?>.social-feed ul.entries > li .social-feed-container{
      border-color: <?= $border_color ?> !important;
    }
    <?php
  } ?>

  <?php if(!empty($font_color)) {
    ?>
    #social-feed-<?=$unique_block_id?>.social-feed ul.entries > li .social-feed-c_content .social-feed-review,
    #social-feed-<?=$unique_block_id?>.social-feed ul.entries > li .social-feed-user .social-feed-user_info time{
      color: <?= $font_color ?> !important;
    }
    <?php
  } ?>

  <?php if(!empty($link_color)) {
    ?>
    #social-feed-<?=$unique_block_id?>.social-feed .social-feed-container .social-feed-c_content a{
      color: <?= $link_color ?> !important;
    }
    <?php
  } ?>

  <?php if(!empty($account_name_color)) {
    ?>
    #social-feed-<?=$unique_block_id?>.social-feed .social-feed-container .social-feed-user_info a{
      color: <?= $account_name_color ?> !important;
    }
    <?php
  } ?>
  </style>


  <div id="social-feed-<?=$unique_block_id?>" class="loading social-feed <?= $template === 'masonry' ? 'masonry' : ''?>" style="
    <?php if(!empty($width)) echo 'width: '. $width .';' ?> <?php if(!empty($height)) echo 'max-height: '. $height .';' ?>">

      <?php if($template === 'tabs'){
        ?>
        <ul class="tabs">
          <?php if($twitter_valid) {
            ?>
            <li>
              <a href="#" data-id="twitter"><i class="social-feed-icon-twitter"></i></a>
            </li>
            <?php
          } ?>
          <?php if($facebook_valid)
          {
            ?>
            <li>
              <a href="#" data-id="facebook"><i class="social-feed-icon-facebook"></i></a>
            </li>
            <?php
          } ?>
          <?php if($instagram_valid) {
            ?>
            <li>
              <a href="#" data-id="instagram"><i class="social-feed-icon-instagram"></i></a>
            </li>
            <?php
          } ?>
          <?php if($youtube_valid) {
            ?>
            <li>
              <a href="#" data-id="youtube"><i class="social-feed-icon-youtube"></i></a>
            </li>
            <?php
          } ?>
        </ul>
        <div class="tabs-content">
          <div id="tab-twitter">
            <ul class="entries"></ul>
          </div>
          <div id="tab-facebook">
            <ul class="entries"></ul>
          </div>
          <div id="tab-instagram">
            <ul class="entries"></ul>
          </div>
          <div id="tab-youtube">
            <ul class="entries"></ul>
          </div>
        </div>
        <?php
      }?>

      <?php if($template !== 'tabs'){
        ?>
        <ul class="entries">
          <li class="grid-sizer"></li>
        </ul>
        <?php
      }?>


      <div class="loading"></div>
      <?php if($load_more){
        ?>
        <div class="load-more-wrapper">
          <a href="#" class="load-more-btn hide" data-skip="0"><?= t('Load More')?></a>
        </div>
        <?php
      }
      ?>
    </div>


    <script type="text/template" id="social-feed-template-<?php echo $unique_block_id?>">
      <li>
        <% if (media && <?= $display_images?>) { %>
          <a href="<%= readMoreUrl %>" target="_blank">
            <img src="<%= media %>" alt="<% name %>"/>
          </a>
          <% } %>
          <div class="social-feed-container <%= socialAccount %>">
            <div class="social-feed-c_content">
              <p class="social-feed-review"><%= text %></p>
            </div>

            <div class="social-feed-user">
              <div class="social-feed-user_avatar">
                <a href="<%= profileUrl %>" target="_blank"><img src="<%= profileImg %>" alt="<%= name %>"></a>
              </div>
              <div class="social-feed-user_info">
                <a href="<%= profileUrl %>" target="_blank" class="social-feed-user_name"><%= name %></a> • <a href="<%= readMoreUrl%>" target="_blank" class="social-feed-post-time"><time class="timeago" datetime="<%= createdAt %>"><%= createdAt %></time></a>
              </div>
            </div>
          </div>
        </li>
      </script>

      <script type="text/javascript">
      $(document).ready(function(){
        
        var timeago_dict = function(number, index, total_sec) {
          var strings = "<?= isset($locale) ? $locale : 'just now, %s seconds ago, 1 minute ago, %s minutes ago, 1 hour ago, %s hours ago, 1 day ago, %s days ago, 1 week ago, %s weeks ago, 1 month ago, %s months ago, 1 year ago, %s years ago'?>";
          
          strings = strings.split(', ');
          
          return [
            [strings[0], 'right now'],
            [strings[1], 'in %s seconds'],
            [strings[2], 'in 1 minute'],
            [strings[3], 'in %s minutes'],
            [strings[4], 'in 1 hour'],
            [strings[5], 'in %s hours'],
            [strings[6], 'in 1 day'],
            [strings[7], 'in %s days'],
            [strings[8], 'in 1 week'],
            [strings[9], 'in %s weeks'],
            [strings[10], 'in 1 month'],
            [strings[11], 'in %s months'],
            [strings[12], 'in 1 year'],
            [strings[13], 'in %s years']
          ][index];
        };
        // register your locale with timeago
        timeago.register('timeago_dict', timeago_dict);

        var timeagoInstance = new timeago();
        var socialFeed = $('#social-feed-<?=$unique_block_id?>');
        var socialFeedEntries = $('ul.entries', socialFeed);
        var loadMoreBtn = $('.load-more-btn', socialFeed);
        var _template = _.template($('#social-feed-template-<?php echo $unique_block_id?>').html());
        var templateType = '<?= $template ?>';
        var isMasonry = templateType === 'masonry';
        var isTabs = templateType === 'tabs';
        var visibleSocialNetwork = 'all';

        if(isMasonry){
          //Initiate masonry plugin
          socialFeedEntries.masonry({
            // options
            itemSelector: 'li',
            percentPosition: true,
            gutter: 10
          });
          var imgLoad = imagesLoaded( socialFeedEntries );

        }

        !isTabs ? getPosts('all', 0) : openTab('<?= $default_tab ?>', true);

        $('.tabs li a', socialFeed).on('click', function(){
          openTab($(this).data('id'), true);
          return false;
        })

        loadMoreBtn.on('click', function(){
          $(this).data('skip', $(this).data('skip') + <?= $posts_limit ?>);
          getPosts(visibleSocialNetwork, $(this).data('skip'));
          $(this).addClass('hide');
          return false;
        })

        function openTab(id, empty){
          $('.tabs li a', socialFeed).removeClass('open');
          $('.tabs-content > div', socialFeed).removeClass('open');
          $('.tabs li a[data-id=' + id + ']', socialFeed).addClass('open');
          $('#tab-' + id, socialFeed).addClass('open');
          if(empty)
          $('.tabs-content > div ul.entries', socialFeed).empty();
          visibleSocialNetwork = id;
          getPosts(id, 0);
          loadMoreBtn.data('skip', 0);
        }


        function getPosts(tab, skip){
          socialFeed.addClass('loading');
          $.ajax({
            type: 'get',
            url: '<?= rtrim($view->url("/"), "/") ?>/easy_social_feed/get/<?= $bID?>/' + tab + '/' + skip,
            dataType: 'json'
          })
          .fail(function(err){
            socialFeed.removeClass('loading');
          })
          .done(function(data){
            socialFeed.removeClass('loading');
            if(data){
              addNewPosts(data);
              if(data.length >= <?= $posts_limit ?>){
                loadMoreBtn.removeClass('hide');
              }
            }
          })
        }
        function addNewPosts(data){
          var generatedTemplate,
          row;
          for(var i = 0; i < data.length; i++){
            row = data[i];
            switch(row.social_account){
              case 'twitter':
              row.text = parseTweet(row.text);
              break;
              case 'facebook':
              row.text = parseFacebook(row.text);
              break;
            }
            generatedTemplate = $(_template({
              socialAccount: row.social_account,
              text: row.text,
              name: row.name,
              profileImg: row.profile_img,
              profileUrl: row.profile_url,
              readMoreUrl: row.read_more_url,
              media: row.media,
              createdAt: row.published_at
            }));
            if(isMasonry){
              socialFeedEntries.append(generatedTemplate).masonry('appended', generatedTemplate);
            }
            else if(isTabs){
              $('#tab-' + row.social_account + ' ul.entries', socialFeed).append(generatedTemplate);
            }
            else{
              socialFeedEntries.append(generatedTemplate);
            }
          }

          socialFeedEntries.imagesLoaded().progress( function() {
            if(isMasonry){
              socialFeedEntries.masonry('layout');
            }
          });
          timeagoInstance.render($('time.timeago'), 'timeago_dict');
        }

        function parseTweet(text){
          text = text.replace(/(https?:\/\/[^ ]+)/g, '<a href="$1" target="_blank" class="social-feed-link-url">$1</a>').
          replace(/(@[^ ]+)/g, '<a href="https://twitter.com/$1" class="social-feed-link-user" target="_blank" >$1</a>').
          replace(/(#[^ ]+)/g, function(t){
            return '<a href="https://twitter.com/search?q=%23' + t.substr(1) + '" class="social-feed-link-hash" target="_blank" >' + t + '</a>'
          });
          return text;
        }

        function parseFacebook(text){
          text = text || '';
          text = text.replace(/(https?:\/\/[^ ]+)/g, '<a href="$1" target="_blank" class="social-feed-link-url">$1</a>');
          return text;
        }
      })
      </script>

      <?php } ?>
