<?php defined('C5_EXECUTE') or die("Access Denied."); ?>
<?php
if ($locale) {
	?>
	<h2><?php echo t("Plugin Settings - %s language", $localeText); ?></h2>

	<p>
		<?php echo t("If you haven't created a %s account or haven't logged in yet, use the button or sign in form available below. When you have selected to use an available widget, those settings will be saved (also if you logout or will be logged out automatically). More widgets can be created using the %s.", sprintf('<a href="%s" target="_blank">%s</a>', 'https://www.tawk.to/', 'Tawk.to'), sprintf('<a href="%s" target="_blank">%s</a>', 'https://dashboard.tawk.to', t('Tawk.to dashboard'))); ?>
	</p>

	<iframe id="tawkIframe"></iframe>

	<a href="<?php echo $this->action('view'); ?>" class="btn btn-primary">
		<i class="fa fa-flag" aria-hidden="true"></i>
		<?php echo t("Back to %s", t("Multilingual Setup")); ?>
	</a>

	<a href="<?php echo URL::to('/dashboard/system/live_chat/settings'); ?>" class="btn btn-primary">
		<i class="fa fa-cog" aria-hidden="true"></i>
		<?php echo t("Back to %s", t("Plugin Settings")); ?>
	</a>

	<script type="text/javascript">
		jQuery('#tawkIframe').attr('src', "<?php echo $iFrameURL; ?>&parentDomain=" + window.location.protocol + "//" + window.location.host);
		window.addEventListener('message', function (e) {
			if (e.origin === '<?php echo $baseURL; ?>') {
				switch (e.data.action) {
					case 'setWidget':
						var postData = {
							pageId: e.data.pageId,
							widgetId: e.data.widgetId
						};
						jQuery.post('<?php echo $this->action('set_widget', $locale); ?>', postData, function (r) {
							var action = r.success ? 'setDone' : 'setFail';
							e.source.postMessage({action: action}, '<?php echo $baseURL; ?>');
						});
						break;
					case 'removeWidget':
						jQuery.post('<?php echo $this->action('remove_widget', $locale); ?>', {}, function (r) {
							var action = r.success ? 'removeDone' : 'removeFail';
							e.source.postMessage({action: action}, '<?php echo $baseURL; ?>');
						});
						break;
				}
			}
		});
	</script>
	<?php
} else {
	if (!empty($localeSections)) {
		?>
		<h2><?php echo t("Choose a locale"); ?></h2>

		<table class="table table-striped">
			<tr>
				<th style="width:40px;">&nbsp;</th>
				<th style="width:40px;"><?php echo t("Configured"); ?></th>
				<th style="width:200px;"><?php echo t("Locale"); ?></th>
				<th style="width:100px;"><?php echo t("Path"); ?></th>
				<th><?php echo t("Name"); ?></th>
			</tr>
			<tbody>
			<?php
			$ch = Core::make('multilingual/interface/flag');
			foreach ($localeSections as $localeSection) {
				$localeSectionLocale = $localeSection->getLocale();
				$localeSectionLanguage = $localeSection->getLanguage();
				$localeSectionLanguageText = $localeSection->getLanguageText();
				$localeSectionIconSrc = $ch->getFlagIcon($localeSection->getIcon());
				$localeSectionURL = $this->action('view', $localeSectionLanguage);
				?>
				<tr>
					<td>
						<a href="<?php echo $localeSectionURL; ?>">
							<?php echo $localeSectionIconSrc; ?>
						</a>
					</td>
					<td style="text-align: center;">
						<?php
						if ($localeSection->configured) {
							echo '<i class="fa fa-check-circle" aria-hidden="true"></i>';
						} else {
							echo '<i class="fa fa-times-circle" aria-hidden="true"></i>';
						} ?>
					</td>
					<td>
						<a href="<?php echo $localeSectionURL; ?>">
							<?php echo $localeSectionLanguageText; ?> (<?php echo $localeSectionLocale; ?>)
						</a>
					</td>
					<td>
						<?php echo $localeSection->getCollectionPath(); ?>
					</td>
					<td>
						<a href="<?php echo $localeSection->getCollectionLink(); ?>" target="_blank">
							<i class="fa fa-external-link" aria-hidden="true"></i>
							<?php echo $localeSection->getCollectionName(); ?>
						</a>
					</td>
				</tr>
				<?php
			} ?>
			</tbody>
		</table>

		<p style="margin-top: 20px;">
			<a href="<?php echo URL::to('/dashboard/system/live_chat/settings'); ?>" class="btn btn-primary">
				<i class="fa fa-cog" aria-hidden="true"></i>
				<?php echo t("Back to %s", t("Plugin Settings")); ?>
			</a>
		</p>
		<?php
	} else {
		?>
		<div class="alert alert-info">
			<i class="fa fa-info-circle"></i>
			<?php echo t("You have no locales setup yet. Go to %s to do so.", sprintf('<a href="%s" target="_blank">%s</a>', URL::to('/dashboard/system/multilingual/setup'), t("Multilingual Setup"))); ?>
		</div>
		<?php
	}
}