<?php defined('C5_EXECUTE') or die("Access Denied.");

/**
 * ab_google_maps package for Concrete5
 * Copyright Copyright 2018-2019, Alex Borisov
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * @author Alex Borisov <linuxoidoz@gmail.com>
 * @package Concrete\Package\ab_google_maps
 */
 
$al = $app->make('helper/concrete/asset_library');

?>

<style>
.ab-google-map-form .text-muted {
    font-size: 0.8em;
}

.ab-google-map-form .spinner-img {
    display: inline-block;
    margin-left: 20px;
}

.ab-google-map-form .spinner-img img {
    border: none !important;
    display: inline-block;
    width: 30px;
    height: 30px;
}

.ab-google-map-form #spinner_list, .ab-google-map-form #spinner_point {
    margin-left: 20px;
    display: inline-block;
}

#google_map {
    width: 100%;
    height: 300px;
    background-color: #eeeeee;
    margin-top: 20px;
    z-index: 0;
}

#google_map .gm-style-iw {
    color: #333333;
    font-size: 0.9em;
}
</style>

<fieldset class="ab-google-map-form">

    <div class="form-group">
        <div class="alert alert-info" role="alert">
        <?php echo t('Click on map to set location'); ?>
        </div>             
        <div id="google_map"></div>
    </div>
        
    <div class="form-group">
        <?php
        echo $form->label('google_api_key', t('Google API Key'));
        echo $form->text('google_api_key', $google_api_key ? $google_api_key : '', ['maxlength' => 256]);
        echo '<p class="text-muted">' . t('Max 256 symbols') . ' (' . t('obtain Google API key at') . ' <a href="https://cloud.google.com/maps-platform" target="_blank">Google Maps Platform</a>)' . '</p>';
        ?>
    </div>
    
    <div class="form-group">
        <?php 
        echo $form->label('location', t('Enter location'));
        echo $form->text('location', $location, ['maxlength' => 256]);
        echo '<p class="text-muted">' . t('Max 256 symbols') . '</p>';
        ?>
    </div>

    <div class="form-group">
        <div class="checkbox" data-checkbox-wrapper="show_geocoding">
            <label>
                <?php
                echo $form->checkbox('show_geocoding', 1, $show_geocoding);
                echo t('Use LocationIQ geocoding to search for location on map');
                ?>
            </label>
        </div>
        <div data-fields="show_geocoding" style="display: none">
            <div class="well">
                <div class="form-group">
                    <?php
                    echo $form->label('locationiq_api_key', t('LocationIQ API Key'));
                    echo $form->text('locationiq_api_key', $locationiq_api_key ? $locationiq_api_key : '', ['maxlength' => 256]);
                    echo '<p class="text-muted">' . t('Max 256 symbols') . ' (' . t('obtain LocationIQ API key at') . ' <a href="https://locationiq.org" target="_blank">LocationIQ.org</a>)' . '</p>';
                    ?>
                </div>
    
                <div class="row">
                    <div class="col-xs-6">
                        <div class="form-group">
                            <?php
                            echo $form->label('server', t('Select Nearest Server'));
                            echo $form->select('server', $servers, $selected_server);
                            ?>
                        </div>
                    </div>
                    <div class="col-xs-6">
                        <div class="form-group">
                            <?php
                            echo $form->label('language', t('Select Map Language'));
                            echo $form->select('language', $languages, $selected_language);
                            ?>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <?php
                    echo $form->button('search', t('Search'), array('style' => 'width: 125px;'), 'btn-primary');
                    echo '<div id="spinner_img" class="spinner-img hidden">';
                    echo '<img src="' . $img_url . '/spinner.gif" />';
                    echo '</div>';
                    echo '<span id="spinner_list" class="text-primary hidden">' . t('Searching locations...') . '</span>';
                    echo '<span id="spinner_point" class="text-primary hidden">' . t('Searching coordinates...') . '</span>';
                    ?>
                </div>
                <div class="form-group">
                    <?php
                    echo $form->label('locations', t('Choose location'));
                    echo $form->select('locations', null, null);
                    ?>
                </div>
            </div>
        </div>
    </div>
        
    <div class="form-group">
        <?php 
        if ($google_api_key == '') {
            echo $form->button('load', t('Load Map'), ['class' => "btn btn-primary"]);
        }
        else {
            echo $form->button('reload', t('Reload Map'), ['class' => "btn btn-primary"]);
            echo '<p class="text-muted">' . t('Return map to previously saved position and update location and coordinates') . '</p>';
        }
        ?>
    </div>
    
    <div class="row">
        <div class="col-xs-6">
            <div class="form-group">
                <?php
                echo $form->label('latitude', t('Location latitude'));
                echo $form->text('latitude', $latitude ? $latitude : "55.753994", ['maxlength' => 20, 'class' => "decimals"]);
                echo '<p class="text-muted">' . t('Max 20 symbols, numeric only') . '</p>';
                ?>
            </div>
        </div>

        <div class="col-xs-6">
            <div class="form-group">
                <?php
                echo $form->label('longitude', t('Location longitude'));
                echo $form->text('longitude', $longitude ? $longitude : "37.622093", ['maxlength' => 20, 'class' => "decimals"]);
                echo '<p class="text-muted">' . t('Max 20 symbols, numeric only') . '</p>';
                ?>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-xs-6">
            <div class="form-group">
                <label class="control-label" for="height" name="height">
                <?php echo t('Map height'); ?>
                <i class="launch-tooltip fa fa-question-circle" title="<?php echo h(t('Set map height with \'px\' or \'%\' only')); ?>"></i>
                </label>
                <div class="input-group">
                <span class="input-group-addon"><i class="fa fa-arrows-v"></i></span>
                <?php echo $form->text('height', $height ? $height : "300px", ['maxlength' => 6]); ?>
                </div>
                <?php echo '<p class="text-muted">' . t('Max 6 symbols') . '</p>'; ?>
            </div>
        </div>

        <div class="col-xs-6">
            <div class="form-group">
                <label class="control-label" for="width" name="width">
                <?php echo t('Map width'); ?>
                <i class="launch-tooltip fa fa-question-circle" title="<?php echo h(t('Set map width with \'px\' or \'%\' only')); ?>"></i>
                </label>
                <div class="input-group">
                <span class="input-group-addon"><i class="fa fa-arrows-h"></i></span>
                <?php echo $form->text('width', $width ? $width : "100%", ['maxlength' => 6]); ?>
                </div>
                <?php echo '<p class="text-muted">' . t('Max 6 symbols') . '</p>'; ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-6">
            <div class="form-group">
                <?php
                echo $form->label('zoom', t('Map zoom'));
                echo $form->number('zoom', $zoom ? $zoom : "16", ['min' => '1', 'max' => '18', 'class' => "decimals"]);
                echo '<p class="text-muted">' . t('Values from 1 to 18') . '</p>';
                ?>
            </div>
        </div>
    </div>
    
    <div class="form-group">
        <div class="checkbox">
            <label>
                <?php
                echo $form->checkbox('lock_wheel', 1, $lock_wheel);
                echo t('Enable mouse wheel zoom over map?');
                ?>
            </label>
        </div>
    </div>
    
    <div class="form-group">
        <div class="alert alert-info" role="alert">
        <?php echo t('Define info to show on map balloon and hint'); ?>
        </div>             
    </div>
        
    <div class="form-group">
        <div class="checkbox" data-checkbox-wrapper="show_name">
            <label>
                <?php
                echo $form->checkbox('show_name', 1, $show_name);
                echo t('Show name at location?');
                ?>
            </label>
        </div>
        <div data-fields="show_name" style="display: none">
            <div class="well">
                <div class="form-group">
                    <?php
                    echo $form->label('name', t('Location name'));
                    echo $form->text('name', $name, ['maxlength' => 256]);
                    echo '<p class="text-muted">' . t('Max 256 symbols') . '</p>';
                    ?>
                </div>
            </div>
        </div>
    </div>
        
    <div class="form-group">
        <div class="checkbox" data-checkbox-wrapper="show_address">
            <label>
                <?php
                echo $form->checkbox('show_address', 1, $show_address);
                echo t('Show alternative address at location?');
                ?>
            </label>
        </div>
        <div data-fields="show_address" style="display: none">
            <div class="well">
                <div class="form-group">
                    <?php
                    echo $form->label('address', t('Alternative location address'));
                    echo $form->text('address', $address, ['maxlength' => 256]);
                    echo '<p class="text-muted">' . t('Max 256 symbols') . '</p>';
                    ?>
                </div>
            </div>
        </div>
    </div>
        
    <div class="form-group">
        <div class="checkbox" data-checkbox-wrapper="show_tel">
            <label>
                <?php
                echo $form->checkbox('show_tel', 1, $show_tel);
                echo t('Show telephone at location?');
                ?>
            </label>
        </div>
        <div data-fields="show_tel" style="display: none">
            <div class="well">
                <div class="form-group">
                    <?php
                    echo $form->label('tel', t('Telephone'));
                    echo $form->text('tel', $tel, ['maxlength' => 256]);
                    echo '<p class="text-muted">' . t('Max 256 symbols') . '</p>';
                    ?>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="checkbox" data-checkbox-wrapper="show_email">
            <label>
                <?php
                echo $form->checkbox('show_email', 1, $show_email);
                echo t('Show email at location?');
                ?>
            </label>
        </div>
        <div data-fields="show_email" style="display: none">
            <div class="well">
                <div class="form-group">
                    <?php
                    echo $form->label('email', t('Email'));
                    echo $form->text('email', $email, ['maxlength' => 256]);
                    echo '<p class="text-muted">' . t('Max 256 symbols') . '</p>';
                    ?>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <div class="checkbox" data-checkbox-wrapper="show_picture">
            <label>
                <?php
                echo $form->checkbox('show_picture', 1, $show_picture);
                echo t('Show picture at location?');
                ?>
            </label>
        </div>
        <div data-fields="show_picture" style="display: none">
            <div class="well">
                <div class="form-group">
                    <?php
                    echo $form->label('picture', t('Picture'));
                    echo $al->image('picture', 'pictureID', t('Choose picture'), $pic);
                    ?>
                </div>
            </div>
        </div>
    </div>

</fieldset>

<script type="text/javascript">
$(function() {
    var myGoogleMap, myGooglePlacemark;
    var latitude = $('#latitude');
    var longitude = $('#longitude');
    
    var google_api_key = $.trim($('#google_api_key').val());
    if (google_api_key == '') {
        ConcreteAlert.error({
            title: <?php echo json_encode(t('Empty Google API Key')); ?>,
            message: <?php echo json_encode(t('Valid Google API Key must be provided')); ?>
        });
    }
    else {
        InitGoogleMap($.trim(latitude.val()), $.trim(longitude.val()));
    }
    
    var ctrl_key_pressed = false;
    $('.decimals').keydown(function (e) {
        if (e.ctrlKey === true || e.metaKey === true) {
            ctrl_key_pressed = true;
        }
        // Allow: ctrl, backspace, delete, tab, escape, enter, - and .
        if ($.inArray(e.keyCode, [17, 8, 46, 9, 27, 13, 109, 173, 110, 190]) !== -1 ||
             // Allow: Ctrl+A, Ctrl+C, Ctrl+V
            (ctrl_key_pressed && (e.keyCode == 65 || e.keyCode == 67 || e.keyCode == 86)) || 
             // Allow: home, end, left, right, down, up
            (e.keyCode >= 35 && e.keyCode <= 40)) {
                 // let it happen, don't do anything
                 ctrl_key_pressed = false;
                 return;
        }
        // Ensure that it is a number and stop the keypress
        if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
            e.preventDefault();
            ConcreteAlert.error({
                title: <?php echo json_encode(t('Oops')); ?>,
                message: <?php echo json_encode(t('Numbers only!')); ?>
            });
        }
    });

    $('#ccm-form-submit-button').on('click', function(e){
        var location = $.trim($('#location').val());
        if (location == '') {
            e.preventDefault();  // stop form from submitting
            e.stopPropagation(); // stop anything else from listening to our event and screwing things up
            ConcreteAlert.error({
                title: <?php echo json_encode(t('Location value error:')); ?>,
                message: <?php echo json_encode(t('Location cannot be empty')); ?>
            });
        }
        
        var lat = $.trim(latitude.val());
        var lon = $.trim(longitude.val());
        if (lat == '' || lon == '') {
            e.preventDefault();  // stop form from submitting
            e.stopPropagation(); // stop anything else from listening to our event and screwing things up
            ConcreteAlert.error({
                title: <?php echo json_encode(t('Coordinates value error:')); ?>,
                message: <?php echo json_encode(t('Coordinates cannot be empty')); ?>
            });
        }
        
        var zoom = parseInt($.trim($('#zoom').val()));
        if (zoom < 1 || zoom > 16) {
            e.preventDefault();  // stop form from submitting
            e.stopPropagation(); // stop anything else from listening to our event and screwing things up
            ConcreteAlert.error({
                title: <?php echo json_encode(t('Zoom value error:')); ?>,
                message: <?php echo json_encode(t('Zoom values can be from 1 to 16')); ?>
            });
        }
        
        var height = $.trim($('#height').val());
        var width = $.trim($('#width').val());
        var regex = /(\d)(px|%)$/;
        if (height == '' || !regex.test(height) || width == '' || !regex.test(width)) {
            e.preventDefault();  // stop form from submitting
            e.stopPropagation(); // stop anything else from listening to our event and screwing things up
            ConcreteAlert.error({
                title: <?php echo json_encode(t('Map height/width value error:')); ?>,
                message: <?php echo json_encode(t('Map height/width values cannot be empty and must end with with \'px\' or \'%\'')); ?>
            });
        }
        
        var email = $.trim($('#email').val());
        var regex = /^([_a-zA-Z0-9-]+)(\.[_a-zA-Z0-9-]+)*@([a-zA-Z0-9-]+)(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,10})$/;
        if (email != '' && !regex.test(email)) {
            e.preventDefault();  // stop form from submitting
            e.stopPropagation(); // stop anything else from listening to our event and screwing things up
            ConcreteAlert.error({
                title: <?php echo json_encode(t('Email value error:')); ?>,
                message: <?php echo json_encode(t('Email address is not valid')); ?>
            });
        }
        
    });
    
    $('#load').on('click', function(e){
        google_api_key = $.trim($('#google_api_key').val());
        if (google_api_key == '') {
            e.preventDefault();
            ConcreteAlert.error({
                title: <?php echo json_encode(t('Empty Google API Key')); ?>,
                message: <?php echo json_encode(t('Valid Google API Key must be provided')); ?>
            });
        }
        else {
            LoadScript(function() {
                InitGoogleMap($.trim(latitude.val()), $.trim(longitude.val()));
            });
        }
    });
    
    $('#reload').on('click', function(e){
        $('#location').val('<?php echo $location; ?>');
        latitude.val('<?php echo $latitude; ?>');
        longitude.val('<?php echo $longitude; ?>');
        ResetGoogleMap();
        InitGoogleMap(<?php echo $latitude; ?>, <?php echo $longitude; ?>);
    });
    
    $('#search').on('click', function(e){
        var location = $.trim($('#location').val());
        if (location == '') {
            ConcreteAlert.error({
                title: <?php echo json_encode(t('Empty Location')); ?>,
                message: <?php echo json_encode(t('Location must be provided')); ?>
            });
            return;
        }
        
        var locationiq_api_key = $.trim($('#locationiq_api_key').val());
        var server = $.trim($('#server').val());
        var language = $.trim($('#language').val());
        
        if (location != '') {
            location = location.replace(/\s/g,"%20");
            var settings = {
            "async": true,
            "crossDomain": true,
            "url": "https://" + server + ".unwiredlabs.com/v2/search.php?token=" + locationiq_api_key + "&q=" + location + "&format=json&accept-language=" + language,
            "method": "GET",
            }
            
            $('#spinner_img').removeClass("hidden");
            $('#spinner_list').removeClass("hidden");
            $.ajax(settings)
            .done(function(response) {
                $('#spinner_img').addClass("hidden");
                $('#spinner_list').addClass("hidden");
                if (response['status'] === "ok") {
                    $('#locations').empty();
                    $('#locations').append($("<option/>").val(0).text('<?php echo t('Select address'); ?>'));
                    $.each(response['address'], function(i, v) {
                        $('#locations').append($("<option/>").val(i+1).text(v['display_name']));
                    });
                }
                else if (response['status'] === "error"){
                    $('#locations').empty();
                    ConcreteAlert.error({
                        title: <?php echo json_encode(t('Geocoding error:')); ?>,
                        message: response['message']
                    });
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                $('#spinner_img').addClass("hidden");
                $('#spinner_list').addClass("hidden");
                ConcreteAlert.error({
                    title: <?php echo json_encode(t('Geocoding failure:')); ?>,
                    message: errorThrown
                });
            });
        }
    });

    $('#locations').on('change', function(e){
        var location = $('#locations option:selected').text();
        var locationiq_api_key = $.trim($('#locationiq_api_key').val());
        var server = $.trim($('#server').val());
        var language = $.trim($('#language').val());
        var lat, lon;
        
        if (parseInt(this.value) > 0) {
            var loc = location.replace(/\s/g,"%20");
            var settings = {
            "async": true,
            "crossDomain": true,
            "url": "https://" + server + ".unwiredlabs.com/v2/search.php?token=" + locationiq_api_key + "&q=" + loc + "&format=json&accept-language=" + language,
            "method": "GET",
            }
            
            $('#spinner_img').removeClass("hidden");
            $('#spinner_point').removeClass("hidden");
            $.ajax(settings)
            .done(function(response) {
                $('#spinner_img').addClass("hidden");
                $('#spinner_point').addClass("hidden");
                if (response['status'] === "ok") {
                    lat = response['address'][0]['lat'];
                    lon = response['address'][0]['lon'];
                    latitude.val(lat);
                    longitude.val(lon);
                    ResetGoogleMap();
                    InitGoogleMap(lat, lon);
                    $('#location').val(location);
                }
                else if (response['status'] === "error"){
                    ConcreteAlert.error({
                        title: <?php echo json_encode(t('Geocoding error:')); ?>,
                        message: response['message']
                    });
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown) {
                $('#spinner_img').addClass("hidden");
                $('#spinner_point').addClass("hidden");
                ConcreteAlert.error({
                    title: <?php echo json_encode(t('Geocoding failure:')); ?>,
                    message: errorThrown
                });
            });
        }
    });

    $('#show_geocoding').on('change', function() {
        $('div[data-fields=show_geocoding]').toggle($(this).is(':checked'));

        if (!$(this).is(':checked')) {
            $('#locations').empty();
        }
    }).trigger('change');

    $('#show_name').on('change', function() {
        $('div[data-fields=show_name]').toggle($(this).is(':checked'));

        if (!$(this).is(':checked')) {
            $('#name').val('');
        }
    }).trigger('change');

    $('#show_address').on('change', function() {
        $('div[data-fields=show_address]').toggle($(this).is(':checked'));

        if (!$(this).is(':checked')) {
            $('#address').val('');
        }
    }).trigger('change');

    $('#show_tel').on('change', function() {
        $('div[data-fields=show_tel]').toggle($(this).is(':checked'));

        if (!$(this).is(':checked')) {
            $('#tel').val('');
        }
    }).trigger('change');

    $('#show_email').on('change', function() {
        $('div[data-fields=show_email]').toggle($(this).is(':checked'));

        if (!$(this).is(':checked')) {
            $('#email').val('');
        }
    }).trigger('change');

    $('#show_picture').on('change', function() {
        $('div[data-fields=show_picture]').toggle($(this).is(':checked'));
    }).trigger('change');

    function ResetGoogleMap() {
        if (myGoogleMap) {
            myGoogleMap = null;
        }
        if (myGooglePlacemark) {
            myGooglePlacemark = null;
        }
    }
    
    function LoadScript(callback) {
        var script = document.createElement('script');
        google_api_key = $.trim($('#google_api_key').val());
        var url = 'https://maps.googleapis.com/maps/api/js?key=' + google_api_key + '&callback=InitGoogleMap';
        script.type = 'text/javascript';
        script.setAttribute('src', url);

        script.onreadystatechange = callback;
        script.onload = callback;

        var head = document.getElementsByTagName('head')[0];
        head.appendChild(script, head);
    };
        
    function InitGoogleMap(lat, lon) {
        google_api_key = $.trim($('#google_api_key').val());
        if (google_api_key == '') {
            ConcreteAlert.error({
                title: <?php echo json_encode(t('Empty Google API Key')); ?>,
                message: <?php echo json_encode(t('Valid Google API Key must be provided')); ?>
            });
            return false;
        }
        
        var locationiq_api_key = $.trim($('#locationiq_api_key').val());
        var location = $.trim($('#location').val());
        lat = lat == '' ? 55.753994 : parseFloat(lat);
        lon = lon == '' ? 37.622093 : parseFloat(lon);
        var zoom = <?php echo $zoom ? (int)$zoom : 16; ?>;
        
        myGoogleMap = new google.maps.Map(document.getElementById('google_map'), {
            center: {
                lat: lat,
                lng: lon,
            },
            zoom: zoom,
        });
        
        myGooglePlacemark = new google.maps.Marker({
            position: {
                lat: lat,
                lng: lon,
            },
            map: myGoogleMap,
            title: location,
            draggable: true,
        });
        
        myGooglePlacemark.addListener('click', function() {
            myGoogleMap.setCenter(myGooglePlacemark.getPosition());
        });
        
        myGooglePlacemark.addListener('drag', function(e) {
            latitude.val(e.latLng.lat());
            longitude.val(e.latLng.lng());
        });
        
        myGoogleMap.addListener('click', function(e) {
            var lat = e.latLng.lat();
            var lon = e.latLng.lng();
            latitude.val(lat);
            longitude.val(lon);
            myGooglePlacemark.setPosition(e.latLng);
            myGoogleMap.setCenter(e.latLng);
            GetName(e.latLng);
        });
    }
    
    function GetName(location) {
        var geocoder = new google.maps.Geocoder;
        var infowindow = new google.maps.InfoWindow;
        geocoder.geocode({'location': location}, function(results, status) {
            if (status === 'OK') {
                if (results[0]) {
                    myGoogleMap.setZoom(11);
                    infowindow.setContent(results[0].formatted_address);
                    infowindow.open(myGoogleMap, myGooglePlacemark);
                } 
                else {
                    ConcreteAlert.error({
                        title: <?php echo json_encode(t('Geocoding Error')); ?>,
                        message: <?php echo json_encode(t('No results found')); ?>
                    });
                }
            } 
            else {
                ConcreteAlert.error({
                    title: <?php echo json_encode(t('Geocoding Error')); ?>,
                    message: <?php echo json_encode(t('Geocoder failed due to')); ?> + ': ' + status
                });
            }
        });
    }
});
</script>
