<?php         
namespace Concrete\Package\AbContactForm;

use Package;
use BlockType;

defined('C5_EXECUTE') or die("Access Denied.");

/**
 * ab_contact_form package for Concrete5
 * concrete5.org marketplace license
 * Copyright Copyright 2017-2018, Alex Borisov
 *
 * @author Alex Borisov <linuxoidoz@gmail.com>
 * @package Concrete\Package\ab_contact_form
 */
 
class Controller extends Package {

	protected $pkgHandle = 'ab_contact_form';
	protected $appVersionRequired = '8.3.0';
	protected $pkgVersion = '0.9.9';
	protected $pkgAutoloaderMapCoreExtensions = true;
	
	public function getPackageDescription() 
	{
		return t('Add contact form with advanced security features');
	}
	
	public function getPackageName() 
	{
		return t("Advanced Contact Form");
	}
	
	public function install() 
	{
		$pkg = parent::install();
		BlockType::installBlockType('ab_contact_form', $pkg);
		if (is_null(\Concrete\Core\Captcha\Library::getByHandle('ab_captcha'))) {
            \Concrete\Core\Captcha\Library::add('ab_captcha', t('Customized Securimage Captcha'), $pkg);
		}
	}

    public function uninstall() 
    {
        $pkg = parent::uninstall();
        $db = $this->app->make('database')->connection();
        $q = 'DROP TABLE IF EXISTS btAbContactFormSpam';
        $v = [''];
        $db->executeQuery($q, $v);
    }

}
