<?php defined('C5_EXECUTE') or die("Access Denied.");
?>
<style>
    .col-xs-12, .col-xs-2, .col-xs-3, .col-xs-4, .col-xs-9{
        padding-left: 0!important;
        padding-right: 0!important;
    }
    .col-xs-12{
        padding-bottom: 10px;
    }
    .mapedit{
        position:absolute;
        z-index:10;
        width:400px;
        height:200px;
        max-width: 100%;
    }
    .gpsbtn {
        margin-top:205px;
        margin-bottom:5px;
    }
    #err_msg{
        display:block;
    }
</style>
<div class="row">
    <div class="col-xs-12">
        <div id="mapedit<?php echo $unique_identifier?>" class="mapedit"></div>
    </div>
    <div class="col-xs-12 gpsbtn">
        <button class="btn btn-primary applygps"><?php echo t("Apply current location using GPS");?></button>
        <span id="err_msg"></span>
    </div>
</div>
<div class="row">
        <div class="col-xs-12">
            <div class="col-xs-2">
                <?php echo $form->label('width', t('width')) ?>
            </div>
            <div class="col-xs-4">
                <?php echo $form->text('width', $width, ['maxlength' => 8]) ?>
            </div>
            <div class="col-xs-2">
                <?php echo $form->label('height', t('height')) ?>
            </div>
            <div class="col-xs-4">
                <?php echo $form->text('height', $height, ['maxlength' => 8]) ?>
            </div>
        </div>
        <div class="col-xs-12">
            <div class="col-xs-3">
                <?php echo $form->label('marker', t('Marker')) ?>
            </div>
            <div class="col-xs-9">
                <?php echo $form->checkbox('marker', 1, $marker) ?><?php echo t('Display a Marker');?>
            </div>
        </div>
        <div class="col-xs-12">
            <div class="col-xs-3">
                <?php echo $form->label('message', t('Message') . t('(max 1000 chars)')) ?>
            </div>
            <div class="col-xs-9">
                <?php echo $form->textarea('message', $message, ['col' => 4, 'maxlength' => 1000]) ?>
            </div>
        </div>
        <div class="col-xs-12">
            <div class="col-xs-3">
                <?php echo $form->label('expert', t('Expert Mode')) ?>
            </div>
            <div class="col-xs-9">
                <?php echo $form->checkbox('expert', 1, $expert) ?><?php echo t('Display lat/lng values');?>
            </div>
        </div>
        <div class="col-xs-12 expert<?php if (!$expert){ echo ' hidden';}?>">
            <div class="col-xs-3">
                <?php echo $form->label('latitude', t('Latitude')) ?>
            </div>
            <div class="col-xs-9">
                <?php echo $form->text('latitude', $latitude, ['maxlength' =>20]) ?>
            </div>
        </div>
        <div class="col-xs-12 expert<?php if (!$expert){ echo ' hidden';}?>">
            <div class="col-xs-3">
                <?php echo $form->label('longitude', t('Longitude')) ?>
            </div>
            <div class="col-xs-9">
                <?php echo $form->text('longitude', $longitude, ['maxlength' =>20]) ?>
            </div>
        </div>
        <div class="col-xs-12 expert<?php if (!$expert){ echo ' hidden';}?>">

            <div class="col-xs-3">
                <?php echo $form->label('zoom', t('Zoom')) ?>
            </div>
            <div class="col-xs-9">
                <?php echo $form->number('zoom', $zoom, ['min' => 1, 'max' => 21, 'step' => 1]) ?>
            </div>
        </div>
        <div class="col-xs-12 expert<?php if (!$expert){ echo ' hidden';}?>">
            <div class="col-xs-3">
                <?php echo $form->label('markerlatitude', t('Marker lat.')) ?>
            </div>
            <div class="col-xs-9">
                <?php echo $form->text('markerlatitude', $markerlatitude, ['maxlength' =>20]) ?>
            </div>
        </div>
        <div class="col-xs-12 expert<?php if (!$expert){ echo ' hidden';}?>">
            <div class="col-xs-3">
                <?php echo $form->label('markerlongitude', t('Marker lng.')) ?>
            </div>
            <div class="col-xs-9">
                <?php echo $form->text('markerlongitude', $markerlongitude, ['maxlength' =>20]) ?>
            </div>
        </div>
        <div class="col-xs-12 expert<?php if (!$expert){ echo ' hidden';}?>">
            <div class="col-xs-4">
                <button class="btn btn-primary commit"><?php echo t('Commit to MAP');?></button>
            </div>
        </div>
</div>
<script>

    $('#mapedit<?php echo $unique_identifier?>').ready(function(){
        setTimeout(function(){

            if (!isNaN($("#latitude").val()) && !isNaN($("#longitude").val()) && !isNaN($("#zoom").val()) ) {
                lat = $("#latitude").val();
                lng = $("#longitude").val();
                zoom = $("#zoom").val();
            } else {
                lat = 35.16809895181293;
                lng = 136.89892888069156;
                zoom = 15;
            }

            var mapedit = L.map('mapedit<?php echo $unique_identifier?>').setView([lat, lng], zoom);

            var tiles = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; <a href="https://openstreetmap.org/copyright">OpenStreetMap</a> contributors'
            });
            mapedit.addLayer(tiles);

            if (!isNaN($("#markerlatitude").val()) && !isNaN($("#markerlongitude").val()) ) {
                markerlat = $("#markerlatitude").val();
                markerlng = $("#markerlongitude").val();
            } else {
                markerlat = lat;
                markerlng = lng;
            }

            var markers = L.marker(
                [markerlat,markerlng],
            );

            if ($("#marker").prop('checked')) {
                markers.addTo(mapedit);
            }

            function onMapMoveend(e) {
                var center = mapedit.getCenter();
                $("#latitude").val(center.lat);
                $("#longitude").val(center.lng);
            }

            mapedit.on('moveend', onMapMoveend);

            function onMapClick(e) {
                markers.setLatLng(e.latlng).addTo(mapedit);
                $("#markerlatitude").val(e.latlng.lat);
                $("#markerlongitude").val(e.latlng.lng);
            }

            mapedit.on('click', onMapClick);

            function onMapZoom(e) {
                var center = mapedit.getZoom();
                $("#zoom").val(center);
            }

            mapedit.on('zoom', onMapZoom);

            $("#marker").on('change',function(){
                if ($(this).prop('checked')) {
                    markers.addTo(mapedit);
                } else {
                    markers.remove();
                }
            });

            $("#expert").on('change',function(){
                if ($(this).prop('checked')) {
                    $(".expert").removeClass('hidden');
                } else {
                    $(".expert").addClass('hidden');
                }
            });

            $("button.commit").on('click',function(e){
                e.preventDefault();
                mapedit.panTo([$("#latitude").val(), $("#longitude").val()]).setZoom($("#zoom").val());
                markers.setLatLng([$("#markerlatitude").val(), $("#markerlongitude").val()]);
            });

            $(".applygps").on('click',function(e){
                e.preventDefault();
                if (location.protocol == 'https:') {
                    navigator.geolocation.getCurrentPosition(successCallback, errorCallback);
                } else {
                    err_msg = "<?php echo t('Https required for accessing your location information.');?>";
                    $("#err_msg").text(err_msg);
                }
            });


            // location access success
            function successCallback(position) {
                mapedit.panTo(
                    [position.coords.latitude, position.coords.longitude]
                );
            }

            // location access failure
            function errorCallback(error) {
                var err_msg = "";
                switch(error.code)
                {
                    case 1:
                        err_msg = "<?php echo t('Location access is not allowed.');?>";
                        break;
                    case 2:
                        err_msg = "<?php echo t('Current position is not obtained.');?>";
                        break;
                    case 3:
                        err_msg = "<?php echo t('Timed out.');?>";
                        break;
                }
                $("#err_msg").text(err_msg);
            }
        });
    });
</script>