<?php

namespace Concrete\Package\MsvAutoTyping;

use Concrete\Core\Block\BlockType\BlockType;
use Concrete\Core\Package\Package;
use Concrete\Core\Asset\AssetList;
use Concrete\Core\Asset\Asset;

class Controller extends Package
{
    protected $pkgHandle = 'msv_auto_typing';
    protected $appVersionRequired = '8.0';
    protected $pkgVersion = '1.0';

    public function getPackageName()
    {
        return t('Auto Typing');
    }

    public function getPackageDescription()
    {
        return t('A block to automatically make typing appear on a page');
    }

    public function install()
    {
        $pkg = parent::install();
        $blockType = BlockType::getByHandle('msv_auto_typing');
        if (!is_object($blockType)) {
            BlockType::installBlockType('msv_auto_typing', $pkg);
        }
    }

    public function on_start()
    {
        $version = $this->getPackageVersion();

        $al = AssetList::getInstance();
        $al->register('javascript', 'msv_typed', 'js/typed.min.js?v=' . $version, ['version' => $version, 'position' => Asset::ASSET_POSITION_FOOTER, 'minify' => false, 'combine' => false], $this);
    }
}


