<?php
defined('C5_EXECUTE') or die("Access Denied.");
/**
 * ab_contact_form package for Concrete5
 * concrete5.org marketplace license
 * Copyright Copyright 2017-2018, Alex Borisov
 *
 * @author Alex Borisov <linuxoidoz@gmail.com>
 * @package Concrete\Package\ab_contact_form
 */
 
$uh = $app->make('helper/concrete/urls');
$bObj = $view->controller->getBlockObject();       
$bt = $bObj->getBlockTypeObject();
$imgURL = $uh->getBlockTypeAssetsURL($bt) . '/images/';

$bUID = $controller->getBlockUID($b);
$formAction = $view->action('submit', $app->make('token')->generate('contact_form'.$bUID));

?>

<script type="text/javascript">
    var js_strings = JSON.parse('<?php echo $js_strings ?>');
</script>

<?php if ($popup) {?>
<div class="contact">
    <a href="#contact-form-<?php echo $bUID; ?>" class="contact-form-a button" data-buid="<?php echo $bUID; ?>"><i class='fa fa-envelope'></i> <?php echo $form_button_text; ?></a>
</div>
<?php }?>

<div class="row <?php if ($popup) { echo "mfp-hide";} ?> contact-form-block" id="contact-form-<?php echo $bUID; ?>">
    <div class="form-group">
        <div id="spinner_img<?php echo $bUID; ?>" class="spinner-img hidden"><img src="<?php echo $imgURL; ?>spinner.gif" /></div>
        <div id="success<?php echo $bUID; ?>" class="success hidden"></div>
        <div id="errors<?php echo $bUID; ?>" class="errors hidden"></div>
    </div>
        
    <form id="contact_form<?php echo $bUID; ?>" 
        class="contact-form" 
        enctype="multipart/form-data" 
        action="<?php echo $formAction?>" 
        method="post" 
        accept-charset="utf-8">
        
        <h2><?php echo $form_title; ?></h2>
        
        <input type="hidden" name="bUID" data-buid="<?php echo $bUID; ?>" data-popup="<?php echo $popup; ?>">
        
        <?php
        echo '<div class="form-group">';
            echo $form->label('name'.$bUID, $entry_name . '<span class="need">' . t('Required') . '</span>');
            echo $form->text('name'.$bUID, "", array ('maxlength'=>"60", 'required'=>"required", 'data-tag'=>'name'));
            echo '<div id="tip-name'.$bUID.'" class="tip-name tip">' . $entry_name_tip . '</div>';
            echo '<div id="error-name'.$bUID.'" class="error-name tip hidden">' . $error_name . '</div>';
        echo '</div>';
        
        echo '<div class="form-group">';
            echo $form->label('email'.$bUID, $entry_email . '<span class="need">' . t('Required') . '</span>');
            echo $form->text('email'.$bUID, "", array ('maxlength'=>"100", 'required'=>"required", 'data-tag'=>'email'));
            echo '<div id="tip-email'.$bUID.'" class="tip-email tip">' . $entry_email_tip . '</div>';
            echo '<div id="error-email'.$bUID.'" class="error-email tip hidden">' . $error_email . '</div>';
        echo '</div>';
        
        echo '<div class="form-group">';
            echo $form->label('message'.$bUID, $entry_message . '<span class="need">' . t('Required') . '</span>');
            echo $form->textarea('message'.$bUID, "", array ('rows'=>"3", 'required'=>"required", 'data-tag'=>'message'));
            echo '<div id="tip-message'.$bUID.'" class="tip-message tip">' . $entry_message_tip . '</div>';
            echo '<div id="error-message'.$bUID.'" class="error-message tip hidden">' . $error_message . '</div>';
        echo '</div>';
        
        if ($show_captcha) {
            $captcha = $app->make('captcha');
            if (\Concrete\Core\Captcha\Library::getActive()->getSystemCaptchaLibraryHandle() === 'ab_captcha') {
                $captcha->setPictureAttributes([
                    'id' => 'captcha_img'.$bUID,
                    'width' => 240,
                    'height' => 60,
                ]);
                
                echo '<div class="form-group">';
                    $captcha->display();
                    echo '<div class="tip">' . $entry_code_img . '</div>';
                echo '</div>';

                echo '<div class="form-group">';
                    echo $form->label('code'.$bUID, $entry_code . '<span class="need">' . t('Required') . '</span>');
                    echo $form->text('code'.$bUID, "", array ('maxlength'=>"6", 'required'=>"required", 'data-tag' => "code"));
                    echo '<div id="tip-code'.$bUID.'" class="tip-code tip">' . $entry_code_tip . '</div>';
                    echo '<div id="error-code'.$bUID.'" class="error-code tip hidden">' . $error_code . '</div>';
                echo '</div>';
            }
            elseif (\Concrete\Core\Captcha\Library::getActive()->getSystemCaptchaLibraryHandle() === 'securimage') {
                echo '<div class="form-group">';
                    $captcha->display();
                    echo '<div class="tip">' . $entry_code_img . '</div>';
                echo '</div>';

                echo '<div class="form-group">';
                    echo $form->label('code'.$bUID, $entry_code . '<span class="need">' . t('Required') . '</span>');
                    echo $form->text('code'.$bUID, "", array ('maxlength'=>"6", 'required'=>"required", 'data-tag' => "code"));
                    echo '<div id="tip-code'.$bUID.'" class="tip-code tip">' . $entry_code_tip . '</div>';
                    echo '<div id="error-code'.$bUID.'" class="error-code tip hidden">' . $error_code . '</div>';
                echo '</div>';
            }
            else {
                echo '<div class="form-group">';
                    $captcha->display();
                    $captcha->showInput();
                echo '</div>';
            }
        }
        
        echo '<div class="form-group">';
                echo $form->submit('submit'.$bUID, $send_button_text, array ('class'=>"button")); 
        echo '</div>';
        ?>
    </form>
</div>
