<?php 
namespace Concrete\Package\SocialStream;
use BlockType,
Package,
AssetList,
SinglePage,
\Concrete\Core\Asset\Asset,
Loader;
defined('C5_EXECUTE') or die("Access Denied.");
class Controller extends Package {

    protected $pkgHandle = 'social_stream';
    protected $appVersionRequired = '5.7.0.4';
    protected $pkgVersion = '1.2.1';

	public function getPackageDescription() {
		return t("Display a consolidated feed of all your social media activity.");
	}
	
	public function getPackageName() {
		return t("Social Stream");
	}
	public function on_start() {
		$al = AssetList::getInstance();
		$al->register(
	 			'javascript', 'lifestream', 'blocks/social_stream/js/socialstream/lifestream.js',
	 			array('version' => '1.0.0', 'position' => Asset::ASSET_POSITION_HEADER, 'minify' => false, 'combine' => false), $this
	 	);
	}

    public function install() {
        $pkg = parent::install();
        // install block 
        BlockType::installBlockTypeFromPackage('social_stream', $pkg); 
		// install dashboard page
		SinglePage::add('/dashboard/social_stream', $pkg);
		if (is_object($p) && $p->isError() !== false) {
            $p->update(array('cName' => t('Social Stream'), 'cDescription' => t('Social Stream Settings')));
        }
		SinglePage::add('/dashboard/social_stream/settings', $pkg);
		if (is_object($p) && $p->isError() !== false) {
            $p->update(array('cName' => t('Settings')));
        }
    }
	public function uninstall(){
		parent::uninstall();
		$db = Loader::db();
		$db->Execute('DROP TABLE IF EXISTS btSocialStream');
	}
}
?>