<?php
namespace Concrete\Package\SocialFeed\Job;

use QueueableJob as AbstractJob;
use \Concrete\Package\SocialFeed\Block\EasySocialFeed\Controller as SocialFeedController;

class SocialFeedUpdate extends AbstractJob
{

  public function getJobName()
  {
    return t('Update Social Feed Data');
  }

  public function getJobDescription()
  {
    return t('Fetches new posts from social media accounts.');
  }

  public function start(\ZendQueue\Queue $q)
  {
      $db = \Database::connection();
      $activeBlocks = $db->GetAll('SELECT b.*
        FROM btEasySocialFeed b
        INNER JOIN CollectionVersionBlocks cvb ON b.bID = cvb.bID
        INNER JOIN CollectionVersions cv ON cvb.cvID = cv.cvID
        WHERE cv.cvIsApproved = 1
        GROUP BY facebook_page_id, instagram_page_id, twitter_page_id, youtube_channel_id
        ORDER BY b.last_update ASC
      ');

      foreach($activeBlocks as $block){
        $q->send(json_encode(array('data' => $block, 'type' => 'facebook')));
        $q->send(json_encode(array('data' => $block, 'type' => 'twitter')));
        $q->send(json_encode(array('data' => $block, 'type' => 'instagram')));
        $q->send(json_encode(array('data' => $block, 'type' => 'youtube')));
      }
  }


  public function processQueueItem(\ZendQueue\Message $msg){
    $socialFeed = new SocialFeed();
    $decodedBody = json_decode($msg->body, true);
    $body = $decodedBody['data'];

     switch($decodedBody['type']){
       case 'facebook':
        $socialFeed->initFacebookUpdate($body);
       break;
       case 'twitter':
        $socialFeed->initTwitterUpdate($body);
       break;
       case 'instagram':
        $socialFeed->initInstagramUpdate($body);
       break;
       case 'youtube':
        $socialFeed->initYoutubeUpdate($body);
       break;
       default:
       break;
     }
  }

  public function finish(\ZendQueue\Queue $q)
  {
      return t('Feed data updated');
  }


}


class SocialFeed extends SocialFeedController
{

}
