<?php defined('C5_EXECUTE') or die("Access Denied."); ?>

<form method="post" id="site-form" action="<?php echo $this->action('save_settings'); ?>"  enctype="multipart/form-data">
<?php echo $this->controller->token->output('save_settings'); ?>
<div class="row">
    <div class="col-md-12 col-lg-6">
		<div class="well">
			<h3><?php echo t('About <em>Social Stream</em>')?></h3>
			<h4><?php echo t('Version ')?><strong>1.0</strong></h4>
			<p><?php echo t('<em>Social Stream</em> allows you to display multiple social network feeds in one consolidated feed.')?></p>
			<p><?php echo t('The feed displays posts from newest to oldest. You can set the number of total posts to display, which combines all set networks.')?></p>
			<hr />
			<h3><?php echo t('Quick Links'); ?></h3>
			<p><?php echo t('Developed by: ')?><a href="http://www.concrete5.org/profile/-/view/11911/" target="_blank"><?php echo t('Growth Curve')?></a><br />
			<?php echo t('Go to: ')?><a href="http://www.concrete5.org/marketplace/addons/social-stream" target="_blank"><?php echo t('Marketplace Page')?></a></p>
		</div>
		<fieldset>
			<legend><?php echo t('Notes'); ?></legend>
			<p><?php echo t('You may wish to save some notes for your own reference here.')?></p>
			<div class="form-group">
				<?php echo $form->textarea('ss_notes', $ss_notes); ?>
			</div>
		</fieldset>
	</div>
	<div class="col-md-12 col-lg-6">
		<h3><?php echo t('User Guide'); ?></h3>
		<div class="panel panel-default">
			<div class="panel-heading"><?php echo t('Usage'); ?></div>
			<div class="panel-body">
				<p><?php echo t('You can display multiple social network feeds in one feed. However, you are limited to only one user per network feed.')?></p>
				<p><?php echo t('More than one <em>Social Stream</em> block can be added to each page. You can also customize the colors.')?></p>
				<p><?php echo t('A network feed becomes active when you enter a username for that network. To disable that network, simply clear out the username.')?></p>
				<p><?php echo t('Not all networks require a username; some use a numeric ID.')?></p>
			</div>
			<div class="panel-heading"><?php echo t('Troubleshoot Guide')?></div>
			<div class="panel-body">
				<table class="table">
					<thead>
						<tr>
							<th><?php echo t('PROBLEM'); ?></th>
							<th><?php echo t('SOLUTION / CAUSE'); ?></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<th><?php echo t('No feed(s) show'); ?></th>
							<td><?php echo t('Incorrect username or ID; no recent posts; network is unavailable.'); ?></td>
						</tr>
						<tr>
							<th><?php echo t('Only one network shows'); ?></th>
							<td><?php echo t('Number of posts exceeds your posts setting'); ?></td>
						</tr>
						<tr>
							<th><?php echo t('Colors do not change'); ?></th>
							<td><?php echo t('Possible conflict with current theme'); ?></td>
						</tr>
						<tr>
							<th><?php echo t('Post link is broken'); ?></th>
							<td><?php echo t('Page is no longer available; post was removed.'); ?></td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
	<div class="ccm-dashboard-form-actions-wrapper">
		<div class="ccm-dashboard-form-actions">
			<button class="pull-right btn btn-success" type="submit" ><?=t('Save')?></button>
		</div>
	</div>
</form>
