<?php 
namespace Concrete\Package\Dashboard4concrete5;

defined('C5_EXECUTE') or die(t('Access denied'));

use SinglePage;
use Package;

class Controller extends Package {

	protected $pkgHandle = 'dashboard4concrete5';
	protected $pkgVersion = '0.9.0';
	protected $appVersionRequired = '5.7.3.1';

	public function getPackageDescription() {
		return t('Dashboard pages for 4Concrete5 packages.');
	}

	public function getPackageName() {
		return t('4Concrete5 Dashboard');
	}

	public function on_start() {}

	public function install() {

		// Install package.
		$pkg = parent::install();

		// Single Pages.
		$sp = SinglePage::add('/dashboard/dashboard4concrete5', $pkg);
		if ($sp) $sp->update(array('cName' => t('4Concrete5 Dashboard'), 'cDescription' => t('Dashboard pages for 4Concrete5 packages.')));
	}

	public function upgrade() {

		// Upgrade package.
		parent::upgrade();
	}

	public function uninstall() {

		// Uninstall package.
		parent::uninstall();
	}

}