<?php defined('C5_EXECUTE') or die("Access Denied.");
$fh = Loader::helper('form/color');
$burl = Loader::helper('concrete/urls') -> getBlockTypeAssetsURL($bt);
$pkg = Package::getByHandle('social_stream');
$pkgVersion = $pkg->getPackageVersion();
$addSelected = true;
?>
<p>
<?php print Core::make('helper/concrete/ui')->tabs(array(
	array('form-add', t('Networks'), $addSelected),
	array('form-options', t('Options')),
	array('form-help', t('Help'))
));?>
</p>
<!-- Begin General Settings Tab -->
<div class="ccm-tab-content" id="ccm-tab-content-form-add">
	<p><?php print Core::make('helper/concrete/ui')->tabs(array(
		array('sub-form-popular', t('Popular'), $addSelected),
		array('sub-form-other', t('Other')), array('sub-form-rss', t('RSS'))
		));?>
	</p>
	<div class="ccm-tab-content" id="ccm-tab-content-sub-form-popular">
		<p><?php echo t('Enter a username (or ID) for any network(s) that you wish to display.')?></p>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('twitter', t('<a href="http://www.twitter.com" target="_blank">Twitter</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('twitter', $twitter);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('youtube', t('<a href="http://www.youtube.com" target="_blank">YouTube</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('youtube', $youtube);?>
				</div>
			</div>
		</fieldset>
	</div>
	<div class="ccm-tab-content" id="ccm-tab-content-sub-form-other">
		<p><?php echo t('Enter a username for any network(s) that you wish to display.')?></p>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('bitbucket', t('<a href="http://www.bitbucket.org" target="_blank">Bitbucket</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('bitbucket', $bitbucket);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
        <div class="form-group">
				<?php  echo $form->label('bitly', t('<a href="http://www.bitly.com" target="_blank">Bitly</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('bitly', $bitly);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('blogger', t('<a href="http://www.blogger.com" target="_blank">Blogger</a>:'));?>
				<div class="input-group">
                <div class="input-group-addon">@</div>
					<?php  echo $form->text('blogger', $blogger);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('citeulike', t('<a href="http://www.citeulike.org" target="_blank">CiteULike</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('citeulike', $citeulike);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('dailymotion', t('<a href="http://www.dailymotion.com" target="_blank">Dailymotion</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('dailymotion', $dailymotion);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('delicious', t('<a href="http://www.delicious.com" target="_blank">Delicious</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('delicious', $delicious);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
            <?php  echo $form->label('deviantart', t('<a href="http://www.deviantart.com" target="_blank">DeviantART</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('deviantart', $deviantart);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('dribbble', t('<a href="http://www.dribbble.com" target="_blank">Dribbble</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('dribbble', $dribbble);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('fancy', t('<a href="http://www.fancy.com" target="_blank">Fancy</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('fancy', $fancy);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('flickr', t('<a href="http://www.flickr.com" target="_blank">Flickr</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('flickr', $flickr);?>
					<div class="input-group-addon"><a href="http://idgettr.com/" target="_blank"><i class="fa fa-question-circle"> </i></a></div>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('formspring', t('<a href="http://www.spring.me" target="_blank">Formspring</a> (Spring.me):'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('formspring', $formspring);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('forrst', t('<a href="http://www.zurb.com/tavern" target="_blank">Forrst</a> (Tavern):'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('forrst', $forrst);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('foursquare', t('<a href="http://www.foursquare.com" target="_blank">Foursquare</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('foursquare', $foursquare);?>
					<div class="input-group-addon"><a href="<?php  echo $burl; ?>/images/help/foursquare.png" target="_blank"><i class="fa fa-question-circle"> </i></a></div>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('gimmebar', t('<a href="http://www.gimmebar.com" target="_blank">Gimme Bar</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('gimmebar', $gimmebar);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('github', t('<a href="http://www.github.com" target="_blank">Github</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('github', $github);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('instapaper', t('<a href="http://www.instapaper.com" target="_blank">Instapaper</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('instapaper', $instapaper);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('lastfm', t('<a href="http://www.last.fm" target="_blank">Last.fm</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('lastfm', $lastfm);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('librarything', t('<a href="http://www.librarything.com" target="_blank">Library Thing</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('librarything', $librarything);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('mlkshk', t('<a href="http://www.mlkshk.com" target="_blank">Mlkshk</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('mlkshk', $mlkshk);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('pinboard', t('<a href="http://www.pinboard.in" target="_blank">Pinboard</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('pinboard', $pinboard);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('pocket', t('<a href="http://www.getpocket.com" target="_blank">Pocket</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('pocket', $pocket);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('quora', t('<a href="http://www.quora.com" target="_blank">Quora</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('quora', $quora);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('reddit', t('<a href="http://www.reddit.com" target="_blank">Reddit</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('reddit', $reddit);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('slideshare', t('<a href="http://www.slideshare.net" target="_blank">SlideShare</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('slideshare', $slideshare);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('snipplr', t('<a href="http://www.snipplr.com" target="_blank">Snipplr</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('snipplr', $snipplr);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('stackoverflow', t('<a href="http://www.stackoverflow.com" target="_blank">Stack Overflow</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('stackoverflow', $stackoverflow);?>
					<div class="input-group-addon"><a href="<?php  echo $burl; ?>/images/help/stackoverflow.png" target="_blank"><i class="fa fa-question-circle"> </i></a></div>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('tumblr', t('<a href="http://www.tumblr.com" target="_blank">Tumblr</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('tumblr', $tumblr);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('vimeo', t('<a href="http://www.vimeo.com" target="_blank">Vimeo</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('vimeo', $vimeo);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('wikipedia', t('<a href="http://www.wikipedia.org" target="_blank">Wikipedia</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('wikipedia', $wikipedia);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('wordpress', t('<a href="http://www.wordpress.com" target="_blank">Wordpress</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('wordpress', $wordpress);?>
				</div>
			</div>
		</fieldset>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('zotero', t('<a href="http://www.zotero.org" target="_blank">Zotero</a>:'));?>
				<div class="input-group">
					<div class="input-group-addon">@</div>
					<?php  echo $form->text('zotero', $zotero);?>
				</div>
			</div>
		</fieldset>
	</div>
	<div class="ccm-tab-content" id="ccm-tab-content-sub-form-rss">
		<p><?php echo t('Enter the URL for the RSS feed you wish to display. Exclude the <em>http://</em>. Example: <em>www.mysite.com/rss</em>')?></p>
		<fieldset>
			<div class="form-group">
				<?php  echo $form->label('rss', t('RSS:'));?>
				<div class="input-group">
					<div class="input-group-addon">http://</div>
					<?php  echo $form->text('rss', $rss);?>
				</div>
			</div>
		</fieldset>
	</div>
</div>
<!-- Begin Options Tab -->
<div class="ccm-tab-content" id="ccm-tab-content-form-options">
	<div class="ccm-block-field-group">
		<div class="row">
			<fieldset>
			<legend><?php echo t('Colors')?></legend>
			<div class="col-xs-6">
				<div class="form-group">
					<label class="form-label"><?php echo t('Background')?></label><br />
					<?php echo $fh->output('bgColor', $bgColor?$bgColor:"#333333"); ?>
				</div>
			</div>
			<div class="col-xs-6">
				<div class="form-group">
					<label class="form-label"><?php echo t('Text')?></label><br />
					<?php echo $fh->output('textColor', $textColor?$textColor:"#d4d4d4"); ?>
				</div>
			</div>
			</fieldset>
		</div>
		<div class="row">
			<fieldset>
			<div class="col-xs-6">
				<div class="form-group">
					<label class="form-label"><?php echo t('Link')?></label><br />
					<?php echo $fh->output('linkColor', $linkColor?$linkColor:"#f6dd97"); ?>
				</div>
			</div>
			<div class="col-xs-6">
				<div class="form-group">
					<label class="form-label"><?php echo t('Link Hover')?></label><br />
					<?php echo $fh->output('linkHoverColor', $linkHoverColor?$linkHoverColor:"#fff5d8"); ?>
				</div>
			</div>
			</fieldset>
		</div>
	</div>
	
	<div class="row">
		<div class="col-xs-12">
			<div class="form-group">
				<?php    echo $form->label('postLimit', t('Post Limit'));?>
				<div class="input-group">        
					<?php   echo $form->number('postLimit', $postLimit?$postLimit:"30", array('min'=>1, 'max'=>500)); ?>
					<div class="input-group-addon"><?php echo t('Posts')?></div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Begin Help Tab -->
<div class="ccm-tab-content" id="ccm-tab-content-form-help">
	<div class="ccm-block-field-group">
		<h3><?php echo t('About Social Stream')?></h3>
		<p><?php echo t('<em>Social Stream</em> allows you to display multiple social network feeds in one consolidated feed.')?></p>
		<p><strong><?php echo t('Version: %s', $pkgVersion);?></strong></p>
		<p><?php echo t('Developed by')?> <a href="http://www.concrete5.org/profile/-/view/11911/" target="_blank">Pine Creative Labs</a></p>
		<p><a href="http://www.concrete5.org/marketplace/addons/social-stream" target="_blank"><?php echo t('Marketplace Page')?></a></p>
	</div>
</div>


<!-- Activate Each Slider Control -->
<script type="text/javascript">
$('input.wtheight_slider').hide();
$('div.wtheight_slider').
  slider(
    { min  : 20,
      step : 5,
      max  : 300,
      value: parseInt($('span.wtheight_slider').text(),10),
      slide: function(event, uiobj) {
               $('span.wtheight_slider').text(uiobj.value+'px');
               $('input.wtheight_slider').val(uiobj.value);
             }
    });
</script>
<script type="text/javascript">
$('input.wtperiod_slider').hide();
$('div.wtperiod_slider').
  slider(
    { min  : 0,
      step : 5,
      max  : 100,
      value: parseInt($('span.wtperiod_slider').text(),10),
      slide: function(event, uiobj) {
               $('span.wtperiod_slider').text(uiobj.value+' ');
               $('input.wtperiod_slider').val(uiobj.value);
             }
    });
</script>
<script type="text/javascript">
$('input.wtamp_slider').hide();
$('div.wtamp_slider').
  slider(
    { min  : 0,
      step : 1,
      max  : 100,
      value: parseInt($('span.wtamp_slider').text(),10),
      slide: function(event, uiobj) {
               $('span.wtamp_slider').text(uiobj.value+' ');
               $('input.wtamp_slider').val(uiobj.value);
             }
    });
</script>
<script type="text/javascript">
$('input.wtlets_slider').hide();
$('div.wtlets_slider').
  slider(
    { min  : 0,
      step : 1,
      max  : 50,
      value: parseInt($('span.wtlets_slider').text(),10),
      slide: function(event, uiobj) {
               $('span.wtlets_slider').text(uiobj.value+' ');
               $('input.wtlets_slider').val(uiobj.value);
             }
    });
</script>