<?php defined('C5_EXECUTE') or die("Access Denied."); ?>

<style>
.social-feed-help{
  margin: 5px 0 10px;
}
.social-feed-help a{
  color: #3f9edc;
}
.social-feed-info {
  color: #3f9edc;
  font-size: 1.2rem;
}
</style>
<?php
$color = Core::make('helper/form/color');
$package = Package::getByHandle('social_feed');
$package_path = $package->getRelativePath() . '/';

echo Core::make('helper/concrete/ui')->tabs(array(
  array('settings', t('Settings'), true),
  array('template', t('Template')),
  array('facebook', t('Facebook')),
  array('instagram', t('Instagram')),
  array('twitter', t('Twitter')),
  array('youtube', t('Youtube')),
  array('update', t('Update')),
  array('help', t('Help'))
));
?>
<div id="social-feed-form-<?=$bID?>">
  <div class="ccm-tab-content" id="ccm-tab-content-settings">
    <div class="social-feed-help">
      <a href="<?= $package_path .'documentation/index.html#!/options'?>" target="_blank"><i class="fa fa-info-circle"></i> <?php echo t('More info')?></a>
    </div>
    <div class="form-group">
      <div class="checkbox">
        <label>
          <?php echo $form->checkbox('update_on_save', 1, $update_on_save); ?>
          <?php echo t("Update feed data on save") ?>
        </label>
      </div>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Posts to display'); ?></label>
      <?php echo $form->number('posts_limit', $posts_limit, array("min" => 1, "max" => 100));?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Width'); ?></label>
      <?php echo $form->text('width', $width);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Height'); ?></label>
      <?php echo $form->text('height', $height);?>
    </div>
    <div class="form-group">
      <div class="social-feed-help">
        <a href="<?= $package_path .'documentation/index.html#!/automated_job'?>" target="_blank"><i class="fa fa-info-circle"></i> <?php echo t('More info about automated jobs')?></a>
      </div>
      <div class="checkbox">
        <label>
          <?php echo $form->checkbox('using_cronjob', 1, $using_cronjob); ?>
          <?php echo t("I am using an automated job to update data") ?>
        </label>
      </div>
    </div>
    <div class="form-group non-cronjob-only-fields <?= $using_cronjob ? 'hidden': ''?>">
      <label class="control-label"><?php echo t('Update every (minutes)'); ?></label>
      <?php echo $form->number('cache_duration', $cache_duration, array("min" => 1, "max" => 60 * 24 * 7));?>
    </div>

    <div class="form-group">
      <div class="checkbox">
        <label>
          <?php echo $form->checkbox('load_more', 1, $load_more); ?>
          <?php echo t("Display Load More button") ?>
        </label>
      </div>
    </div>
    <div class="form-group">
      <div class="checkbox">
        <label>
          <?php echo $form->checkbox('display_images', 1, $display_images); ?>
          <?php echo t("Display Images") ?>
        </label>
      </div>
    </div>
    <div class="locale">
      <label class="control-label"><?php echo t('Locale strings'); ?></label>
      <p class="social-feed-info">just now, %s seconds ago, 1 minute ago, %s minutes ago, 1 hour ago, %s hours ago, 1 day ago, %s days ago, 1 week ago, %s weeks ago, 1 month ago, %s months ago, 1 year ago, %s years ago
      </p>
      <?php echo $form->text('locale', $locale);?>
    </div>
  </div>

  <div class="ccm-tab-content" id="ccm-tab-content-template">
    <div class="social-feed-help">
      <a href="<?= $package_path .'documentation/index.html#!/templates'?>" target="_blank"><i class="fa fa-info-circle"></i> <?php echo t('More info')?></a>
    </div>
    <div class="form-group">
      <?php  echo $form->label('background_color', t('Background Color'));?>
      <div class="input-group">
        <?php  $color->output('background_color', $background_color, array('preferredFormat' => 'hex')); ?>
      </div>
    </div>
    <div class="form-group">
      <?php  echo $form->label('border_color', t('Border Color'));?>
      <div class="input-group">
        <?php  $color->output('border_color', $border_color, array('preferredFormat' => 'hex')); ?>
      </div>
    </div>
    <div class="form-group">
      <?php  echo $form->label('font_color', t('Font Color'));?>
      <div class="input-group">
        <?php  $color->output('font_color', $font_color, array('preferredFormat' => 'hex')); ?>
      </div>
    </div>
    <div class="form-group">
      <?php  echo $form->label('link_color', t('Link Color'));?>
      <div class="input-group">
        <?php  $color->output('link_color', $link_color, array('preferredFormat' => 'hex')); ?>
      </div>
    </div>
    <div class="form-group">
      <?php  echo $form->label('account_name_color', t('Account Name Color'));?>
      <div class="input-group">
        <?php  $color->output('account_name_color', $account_name_color, array('preferredFormat' => 'hex')); ?>
      </div>
    </div>
    <div class="form-group">
      <?php  echo $form->label('template', t('Template'))?>
      <?php  echo $form->select('template', array('default' => t('Default'), 'tabs' => t('Tabs'), 'masonry' => t('Masonry')), $template)?>
    </div>
    <div class="form-group masonry-only-fields <?= $template !== 'masonry' ? 'hidden': ''?>">
      <?php  echo $form->label('masonry_cols', t('Masonry Columns'))?>
      <?php  echo $form->select('masonry_cols', array('1' => t('1'), '2' => t('2'), '3' => t('3'), '4' => t('4'),'5' => t('5'), '6' => t('6')), $masonry_cols)?>
    </div>
    <div class="form-group masonry-only-fields <?= $template !== 'masonry' ? 'hidden': ''?>">
      <?php  echo $form->label('masonry_cols_tablet', t('Masonry Columns on Tablet'))?>
      <?php  echo $form->select('masonry_cols_tablet', array('1' => t('1'), '2' => t('2'), '3' => t('3'), '4' => t('4'),'5' => t('5'), '6' => t('6')), $masonry_cols_tablet)?>
    </div>
    <div class="form-group masonry-only-fields <?= $template !== 'masonry' ? 'hidden': ''?>">
      <?php  echo $form->label('masonry_cols_mobile', t('Masonry Columns on Mobile'))?>
      <?php  echo $form->select('masonry_cols_mobile', array('1' => t('1'), '2' => t('2'), '3' => t('3'), '4' => t('4'),'5' => t('5'), '6' => t('6')), $masonry_cols_mobile)?>
    </div>
    <div class="form-group <?= $template !== 'tabs' ? 'hidden': ''?>" id="default-tab">
      <?php  echo $form->label('default_tab', t('Default Tab'))?>
      <?php  echo $form->select('default_tab', array('twitter' => t('Twitter'), 'facebook' => t('Facebook'), 'instagram' => t('Instagram'), 'youtube' => t('Youtube')), $default_tab)?>
    </div>
  </div>

  <div class="ccm-tab-content" id="ccm-tab-content-facebook">
    <div class="social-feed-help">
      <a href="<?= $package_path .'documentation/index.html#!/facebook_api_credentials'?>" target="_blank"><i class="fa fa-info-circle"></i> <?php echo t('Getting the keys')?></a>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('App ID'); ?></label>
      <?php echo $form->text('facebook_key', $facebook_key);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('App Secret'); ?></label>
      <?php echo $form->text('facebook_secret', $facebook_secret);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('App Access Token'); ?></label>
      <?php echo $form->text('facebook_access_token', $facebook_access_token);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Page ID'); ?></label>
      <?php echo $form->text('facebook_page_id', $facebook_page_id, array('placeholder' => '224898291253860'));?>
    </div>
  </div>

  <div class="ccm-tab-content" id="ccm-tab-content-instagram">
    <div class="social-feed-help">
      <a href="<?= $package_path .'documentation/index.html#!/instagram_api_credentials'?>" target="_blank"><i class="fa fa-info-circle"></i> <?php echo t('Getting the keys')?></a>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Client ID'); ?></label>
      <?php echo $form->text('instagram_key', $instagram_key);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Client Secret'); ?></label>
      <?php echo $form->text('instagram_secret', $instagram_secret);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Access Token'); ?></label>
      <?php echo $form->text('instagram_access_token', $instagram_access_token);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('User ID'); ?></label>
      <?php echo $form->text('instagram_page_id', $instagram_page_id, array('placeholder' => '1744099729'));?>
    </div>
  </div>

  <div class="ccm-tab-content" id="ccm-tab-content-twitter">
    <div class="social-feed-help">
      <a href="<?= $package_path .'documentation/index.html#!/twitter_api_credentials'?>" target="_blank"><i class="fa fa-info-circle"></i> <?php echo t('Getting the keys')?></a>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Access Token'); ?></label>
      <?php echo $form->text('twitter_key', $twitter_key);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Access Token Secret'); ?></label>
      <?php echo $form->text('twitter_secret', $twitter_secret);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Consumer Key'); ?></label>
      <?php echo $form->text('twitter_consumer_key', $twitter_consumer_key);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Consumer Secret'); ?></label>
      <?php echo $form->text('twitter_consumer_secret', $twitter_consumer_secret);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Username'); ?></label>
      <?php echo $form->text('twitter_page_id', $twitter_page_id, array('placeholder' => 'bbcworld'));?>
    </div>
    <div class="form-group">
      <div class="checkbox">
        <label>
          <?php echo $form->checkbox('twitter_exclude_replies', 1, $twitter_exclude_replies); ?>
          <?php echo t("Exclude Replies") ?>
        </label>
      </div>
    </div>
    <div class="form-group">
      <div class="checkbox">
        <label>
          <?php echo $form->checkbox('twitter_exclude_retweets', 1, $twitter_exclude_retweets); ?>
          <?php echo t("Exclude Retweets") ?>
        </label>
      </div>
    </div>
  </div>

  <div class="ccm-tab-content" id="ccm-tab-content-youtube">
    <div class="social-feed-help">
      <a href="<?= $package_path .'documentation/index.html#!/youtube_api_credentials'?>" target="_blank"><i class="fa fa-info-circle"></i> <?php echo t('Getting the keys')?></a>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Key'); ?></label>
      <?php echo $form->text('youtube_key', $youtube_key);?>
    </div>
    <div class="form-group">
      <label class="control-label"><?php echo t('Channel ID'); ?></label>
      <?php echo $form->text('youtube_channel_id', $youtube_channel_id, array('placeholder' => 'UCGE4GWXwJi6TtN4fLB-zRdQ'));?>
    </div>
  </div>

  <div class="ccm-tab-content" id="ccm-tab-content-update">
    <p>
      To update social media data manually, go to Automated Jobs page in your admin area and run a job "Update Social Feed Data".
    </p>
    <a href="<?= $view->url("/") ?>/dashboard/system/optimization/jobs" class="btn btn-primary" target="_blank">Go to Automated Jobs</a>
  </div>

  <div class="ccm-tab-content" id="ccm-tab-content-help">
    <a href="<?= $package_path .'documentation/index.html'?>" class="btn btn-primary" target="_blank"><?php echo t('Check Documentation') ?></a>
  </div>
  <input type="hidden" name="twitter_last_id" value="<?= $twitter_last_id?>"/>
  <input type="hidden" name="facebook_last_id" value="<?= $facebook_last_id?>"/>
  <input type="hidden" name="youtube_last_id" value="<?= $youtube_last_id?>"/>
  <input type="hidden" name="instagram_last_id" value="<?= $instagram_last_id?>"/>
</div>

<script>
$(document).ready(function() {
  var container = $('#social-feed-form-<?=$bID?>');
  $('#template', container).on('change', function(){
    if($(this).val() === 'tabs'){
      $('#default-tab', container).removeClass('hidden');
    }
    else{
      $('#default-tab', container).addClass('hidden');
    }

    if($(this).val() === 'masonry'){
      $('.masonry-only-fields', container).removeClass('hidden');
    }
    else{
      $('.masonry-only-fields', container).addClass('hidden');
    }
  })

  $('#using_cronjob', container).on('change', function(){
    if($(this).is(':checked')){
      $('.non-cronjob-only-fields', container).addClass('hidden');
    }
    else{
      $('.non-cronjob-only-fields', container).removeClass('hidden');
    }
  })

  $('#facebook_page_id', container).on('change', function(){
    $('input[name="facebook_last_id"]', container).val('');
  })
  $('#twitter_page_id', container).on('change', function(){
    $('input[name="twitter_last_id"]', container).val('');
  })
  $('#instagram_page_id', container).on('change', function(){
    $('input[name="instagram_last_id"]', container).val('');
  })
  $('#youtube_channel_id', container).on('change', function(){
    $('input[name="youtube_last_id"]', container).val('');
  })
})
</script>
