<?php    
/*
*
* Copyright (c) 2012-2016 Marc Geldon <marc@geldon.de> - www.geldon.de
*
* Permission is hereby granted, free of charge, to any person obtaining a 
* copy of this software and associated documentation files (the 
* "Software"), to deal in the Software without restriction, including 
* without limitation the rights to use, copy, modify, merge, publish, 
* distribute, sublicense, and/or sell copies of the Software, and to 
* permit persons to whom the Software is furnished to do so, subject to 
* the following conditions: 
* 
* The above copyright notice and this permission notice shall be included 
* in all copies or substantial portions of the Software. 
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 

* @author Marc Geldon <marc@geldon.de>
* @copyright Copyright (c) 2012-2016 Marc Geldon - www.geldon.de
* @license MIT License
*/
namespace Concrete\Package\SiClearCache;

defined('C5_EXECUTE') or die(_("Access Denied."));

use \Concrete\Core\Job\Job;
use \Concrete\Core\Package\Package;

class Controller extends Package {

	protected $pkgHandle = 'si_clear_cache';
	protected $appVersionRequired = '5.7.5.7';
	protected $pkgVersion = '1.1'; 
	
	public function getPackageName() {
		return t("SCALA Clear Cache"); 
	}	
	
	public function getPackageDescription() {
		return t("This package provides a simple job which clear the concrete5 cache");
	}
	
	public function install() {
		$pkg = parent::install();
		
		Job::installByPackage('si_clear_cache', $pkg);
	}
	
	public function uninstall() {
		$pkg = parent::uninstall();
	}	
}